unit CGIXML21;

{
  Demonstration of the TRecordPageProducer component to generate XML.
  Requires 'movie-watcher' alias to be set up in BDE.

  Copyright  Keith Wood (kbwood@iprimus.com.au)
  Written 17 August, 1999.
}

interface

uses
  SysUtils, Classes,
{$IFDEF D6UP}
  HTTPProd,
{$ELSE}
  HTTPApp,
{$ENDIF}
  Db, DBTables, RecPageProd, HTTPProd;

type
  TwmdXML = class(TWebModule)
    tblMovie: TTable;
      tblMovieMovie_id: TAutoIncField;
      tblMovieName: TStringField;
      tblMovieRating: TStringField;
      tblMovieLength_Mins: TIntegerField;
      tblMovieDirector: TStringField;
      tblMovieSynopsis: TMemoField;
      tblMovieURL: TStringField;
      tblMovieLogo_URL: TStringField;
    tblCinema: TTable;
      tblCinemaCinema_id: TAutoIncField;
      tblCinemaName: TStringField;
      tblCinemaPhone: TStringField;
      tblCinemaAddress: TStringField;
      tblCinemaDirections: TMemoField;
      tblCinemaCandy_bar: TBooleanField;
      tblCinemaDisabled_access: TBooleanField;
    tblScreening: TTable;
      tblScreeningMovie_id: TIntegerField;
      tblScreeningCinema_id: TIntegerField;
      tblScreeningStart_date: TDateField;
      tblScreeningEnd_date: TDateField;
      tblScreeningDigital_sound: TStringField;
      tblScreeningNo_passes: TBooleanField;
    dsrMovie: TDataSource;
    dsrCinema: TDataSource;
    dsrScreening: TDataSource;
    tblStars: TTable;
      tblStarsStar_id: TAutoIncField;
      tblStarsMovie_id: TIntegerField;
      tblStarsStar: TStringField;
    tblPricing: TTable;
      tblPricingPricing_id: TAutoIncField;
      tblPricingCinema_id: TIntegerField;
      tblPricingName: TStringField;
      tblPricingPeriod: TStringField;
      tblPricingAdult: TFloatField;
      tblPricingChild: TFloatField;
      tblPricingDiscount: TFloatField;
    tblSessions: TTable;
      tblSessionsMovie_id: TIntegerField;
      tblSessionsCinema_id: TIntegerField;
      tblSessionsTime: TTimeField;
      tblSessionsPricing_id: TIntegerField;
    pgpMovieWatcher: TPageProducer;
    pgrMovies: TRecordPageProducer;
    pgrCinemas: TRecordPageProducer;
    pgrScreenings: TRecordPageProducer;
    pgrStars: TRecordPageProducer;
    pgrPricing: TRecordPageProducer;
    pgrSessions: TRecordPageProducer;
    procedure wmdXMLwacXMLAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure pgpMovieWatcherHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: string; TagParams: TStrings; var ReplaceText: string);
    procedure pgrMovieHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: string; TagParams: TStrings; var ReplaceText: string);
    procedure pgrCinemaHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: string; TagParams: TStrings; var ReplaceText: string);
    procedure pgrScreeningHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: string; TagParams: TStrings; var ReplaceText: string);
    procedure AttributeGetText(Sender: TField; var Text: string;
      DisplayText: Boolean);
    procedure EmptyFieldGetText(Sender: TField; var Text: string;
      DisplayText: Boolean);
    procedure MemoGetText(Sender: TField; var Text: string;
      DisplayText: Boolean);
  private
    function ModifyName(Name: string): string;
  public
  end;

var
  wmdXML: TwmdXML;

implementation

{$R *.DFM}

{ Main response }
procedure TwmdXML.wmdXMLwacXMLAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  Response.ContentType := 'text/xml';
  Response.Content     := pgpMovieWatcher.Content;
  Handled              := True;
end;

{ Convert field names to XML names }
function TwmdXML.ModifyName(Name: string): string;
begin
  Result := LowerCase(StringReplace(Name, '_', '-', [rfReplaceAll]));
end;

{ Generate movie-watcher XML document }
procedure TwmdXML.pgpMovieWatcherHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: string; TagParams: TStrings; var ReplaceText: string);
begin
  if TagString = 'movies' then
    ReplaceText := pgrMovies.Content
  else if TagString = 'cinemas' then
    ReplaceText := pgrCinemas.Content
  else if TagString = 'screenings' then
    ReplaceText := pgrScreenings.Content;
end;

{ Add details for a movie }
procedure TwmdXML.pgrMovieHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: string; TagParams: TStrings; var ReplaceText: string);
begin
  if TagString = 'stars' then
    ReplaceText := pgrStars.Content;
end;

{ Add details for a cinema }
procedure TwmdXML.pgrCinemaHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: string; TagParams: TStrings; var ReplaceText: string);
begin
  if TagString = 'pricing' then
    ReplaceText := pgrPricing.Content;
end;

{ Add details for a film screening }
procedure TwmdXML.pgrScreeningHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: string; TagParams: TStrings; var ReplaceText: string);
begin
  if TagString = 'sessions' then
    ReplaceText := pgrSessions.Content;
end;

{ Include attributes only if present }
procedure TwmdXML.AttributeGetText(Sender: TField; var Text: string;
  DisplayText: Boolean);
begin
  if Sender.AsString <> '' then
    Text := ' ' + ModifyName(Sender.FieldName) + '="' + Sender.AsString + '"';
end;

{ Include empty field tag only if flag in DB set }
procedure TwmdXML.EmptyFieldGetText(Sender: TField;
  var Text: string; DisplayText: Boolean);
begin
  if Sender.AsBoolean then
    Text := '<' + ModifyName(Sender.FieldName) + '/>';
end;

{ Display longer text }
procedure TwmdXML.MemoGetText(Sender: TField; var Text: string;
  DisplayText: Boolean);
begin
  Text := Sender.AsString;
end;

end.
